@php use App\Enums\Media\MediaCollection;use Illuminate\Support\Str; @endphp
@php
    $currentPage = $products->currentPage();
    $perPage = $products->perPage();
    $total = $products->total();
    $from = ($currentPage - 1) * $perPage + 1;
    $to = min($currentPage * $perPage, $total);
@endphp

<div class="col-md-9 buy-now-cards">
    <h5 class="showing-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
        {{ __('lang.showing_text', ['from' => $from, 'to' => $to, 'total' => $total]) }}
    </h5>
    <div class="row">
        <!-- Product Card -->
        @foreach($products as $product)
            <div class="col-md-4 mb-4">
                <div class="buy-now-card" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <a href="{{ route($product_route_name, ['slug' => $product->slug]) }}">
                        <img src="{{ $product->getFirstMediaUrl($image_collection) }}" class="buy-img-card"
                             alt="Product Image">
                    </a>
                    <div class="buy-now-card-body">
                            <h5 class="buy-now-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <a href="{{ route($product_route_name, ['slug' => $product->slug]) }}" style="color: black">
                                    {{ getColumn($product, 'name') }}
                                </a>
                            </h5>

                         <a href="{{ route($product_route_name, ['slug' => $product->slug]) }}" style="color: black">
                            <p class="buy-now-desc" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                    {!! getColumn($product, isset($type) && $type == 'courses' ? 'short_description' : 'description' ) !!}
                            </p>
                            </a>

                        <div class="buy-now-prices  d-flex align-items-center " data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            @if( $product->sale_price)
                                <h5 class="original-price mx-2"><span>$</span>{{ $product->price }}</h5>
                                <h5 class="discounted-price"><span>$</span>{{ $product->sale_price  }}</h5>
                            @else
                                <h5 class="discounted-price"><span>$</span>{{ $product->price  }}</h5>
                            @endif
                        </div>

                        <a href="{{ route($product_route_name, ['slug' => $product->slug]) }}" class="buy-now-btn"
                           data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            {{ __('lang.buy_now') }}
                        </a>
                        <a href="{{ route($product_route_name, ['slug' => $product->slug]) }}"
                           class="buynow-see-details" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            {{ __('lang.see_details') }}
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Pagination Section -->
    <!-- Pagination Section -->
    <nav aria-label="Page navigation" class="custom-pagination">
        <ul class="pagination justify-content-center">
            {{$products->appends(request()->query())->links("pagination::bootstrap-4")}}

        </ul>
    </nav>
</div>
