<?php

namespace App\Services\Website\Testimonial;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\TestimonialRepositoryInterface;
use App\Services\BaseService;

class GetTestimonialService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly TestimonialRepositoryInterface $testimonialRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->testimonialRepository->get($this->dto);
    }
}
