<?php

namespace App\Repositories\Interfaces;


use App\DTOs\AbstractDTO;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

interface CourseRepositoryInterface
{

    public function get(AbstractDTO $DTO);
    public function getIsFeaturedCourses(AbstractDTO $dto): Collection;

    public function getBySlug(string $slug): ?Model;
    public function getInterestedCourses(AbstractDTO $dto, string $categoryId): Collection;
}

