<?php

namespace App\Repositories;


use App\DTOs\AbstractDTO;
use App\Models\Brand;
use App\Repositories\Interfaces\BrandRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class BrandRepository extends Repository implements BrandRepositoryInterface
{
    public function __construct(Brand $model)
    {
        $this->setModel($model);
    }

    public function get(AbstractDTO $dto): ?Collection
    {
        return $this->getModel()->active()
            ->when($dto->getLimit(), function ($query) use ($dto) {
                $query->limit($dto->getLimit());
            })
            ->orderBy('created_at', 'desc')

            ->get();
    }
}

