<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Video extends BaseModel implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;


    protected $table = 'videos';
    protected $fillable = ['course_id', 'title_ar', 'title_en', 'url'];

    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class);
    }

}
